


export class SlotplanMonthWidget {
	
	

	tpl = `
		<div class="slotplan-config-month" ez-for="months" ez-item="month">
		
			<div class="month-no month-{{month.monthno}}" monthno="{{month.monthno}}">
				<input type="checkbox" 
						id="month-no-{{month.monthno}}" 
						class="months-planned" 
						[checked]="{{month.active}}" />
				
				<label for="month-no-{{month.monthno}}" class="month-title">{{ _('month.'+month.monthno) }}</label>
				
				<ez-select name="month{{month.monthno}}-pricetype" 
							label="Prijstype" 
							[value]="month.slotplanPricetypeId"
							[options]="pricetypes"></ez-select>
			</div>

		</div>
	`;
	
	
	container = null;
	
	slotplan = null;
	
	months = {};
	pricetypes = [];
	
	
	constructor( slotplan, pricetypes ) {
		this.slotplan = slotplan;
		this.pricetypes = pricetypes;
	}
	
	getMonths() {
		for(let i=1; i <= 12; i++) {
			let ptid = $('.slotplan-config-month').find('select[name=month'+i+'-pricetype]').val();
				
			let active = $('.slotplan-config-month').find('input#month-no-'+i).prop('checked') ? 1 : 0;
			
			this.months[i].slotplanPricetypeId = ptid;
			this.months[i].active = active;
		}
		
		return this.months;
	}
	
	init( e ) {
		this.container = e;
		
		// init months
		this.months = {};
		for(let i=1; i <= 12; i++) {
			this.months[i] = {
				monthno: i
			};
		}
		
		// set values
		if ( this.slotplan && this.slotplan.slotitemMonths ) {
			for(let i in this.slotplan.slotitemMonths) {
				let sid = this.slotplan.slotitemMonths[i];
				
				if (sid.monthno >= 1 && sid.monthno <= 12)
					this.months[ sid.monthno ] = sid;
			}
		}
	}
	
	
	render() {
		let ht = new EzTemplate( this.container );
		ht.setObject('widget', this);
		ht.setVar('months', this.months);
		ht.setVar('pricetypes', this.pricetypes);
		ht.loadHtml( this.tpl );
		
		ht.render();
	}
	
	
	
	
}



